IF OBJECT_ID('P_EXP_CTB_EXP_MOV ') IS NOT NULL
    BEGIN
        DROP PROCEDURE P_EXP_CTB_EXP_MOV ;
    END;
GO


CREATE PROCEDURE P_EXP_CTB_EXP_MOV (@CD_EMP         INT,
                                   @CD_FILIAL      INT,
                                   @DT_INI         DATETIME,
                                   @DT_FIM         DATETIME,
                                   @FLAG_CONSULTAR INT      = 0)
WITH ENCRYPTION
AS
     BEGIN
         DECLARE @TIPO INT;
		 
		 PRINT 'P_EXP_CTB_EXP_MOV  - SELECT 1 '+CONVERT(VARCHAR, GETDATE(), 108);
         SET @TIPO =
         (
             SELECT DBO.UFD_BUSCA_PARAM_SISTEMA(1, 'FLAG_TRANSF_VLR_TES', 0, 0)
         );
		  
		 DECLARE @TIPO_RECBTO_CLIENTE INT;

		 PRINT 'P_EXP_CTB_EXP_MOV  - SELECT 2 '+CONVERT(VARCHAR, GETDATE(), 108);
         SET @TIPO_RECBTO_CLIENTE =
         (
             SELECT DBO.UFD_BUSCA_PARAM_SISTEMA(1, 'FLAG_EXP_CONTABIL_RECBTO_CLI_MOEDAS',  0, 0)
         );

         SET NOCOUNT ON;
         
         ------------------------------------------------------------------------------------------------------------------------------
         --CRIANDO A TABELA TEMPORARIA #CTB_EXP_MOV
         ------------------------------------------------------------------------------------------------------------------------------
         PRINT 'EXEC 2 '+CONVERT(VARCHAR, GETDATE(), 108);
		 EXEC P_EXP_CTB_MOV_CRIAR_CTB_EXP_MOV 1;
          
         ------------------------------------------------------------------------------------------------------------------------------
         --FUNCAO VB - GeraMovimentoImpostoDevolucaoVendas
         ------------------------------------------------------------------------------------------------------------------------------
		PRINT 'EXEC 3 '+CONVERT(VARCHAR, GETDATE(), 108);        
		EXEC P_EXP_CTB_MOV_IMP_DEV_VENDA 
              @CD_EMP,
              @CD_FILIAL,
              @DT_INI,
              @DT_FIM;
         
         ------------------------------------------------------------------------------------------------------------------------------
         --FUNCAO VB - GeraMovimentoDevolucoesContabil
         ------------------------------------------------------------------------------------------------------------------------------
         PRINT 'EXEC 4 '+CONVERT(VARCHAR, GETDATE(), 108);
		 EXEC P_EXP_CTB_MOV_VENDAS_CONTABIL 
              @CD_EMP,
              @CD_FILIAL,
              @DT_INI,
              @DT_FIM;
			  
         PRINT 'EXEC 5 '+CONVERT(VARCHAR, GETDATE(), 108);
         EXEC P_EXP_CTB_MOV_VENDAS_CONTABIL_CHEQUE_PRAZO 
              @CD_EMP,
              @CD_FILIAL,
              @DT_INI,
              @DT_FIM;
			  
         PRINT 'EXEC 6 '+CONVERT(VARCHAR, GETDATE(), 108);
         EXEC P_EXP_CTB_MOV_VENDAS_CONTABIL_CARTAO 
              @CD_EMP,
              @CD_FILIAL,
              @DT_INI,
              @DT_FIM;
			  
         PRINT 'EXEC 7 '+CONVERT(VARCHAR, GETDATE(), 108);
         EXEC P_EXP_CTB_MOV_VENDAS_CONTABIL_CONVENIO 
              @CD_EMP,
              @CD_FILIAL,
              @DT_INI,
              @DT_FIM;
			  
         PRINT 'EXEC 8 '+CONVERT(VARCHAR, GETDATE(), 108);
         EXEC P_EXP_CTB_MOV_VENDAS_CONTABIL_IMPOSTOS 
              @CD_EMP,
              @CD_FILIAL,
              @DT_INI,
              @DT_FIM;
			  
         PRINT 'EXEC 9 '+CONVERT(VARCHAR, GETDATE(), 108);
         EXEC P_EXP_CTB_MOV_VENDAS_CONTABIL_CUSTO 
              @CD_EMP,
              @CD_FILIAL,
              @DT_INI,
              @DT_FIM;
			
         ------------------------------------------------------------------------------------------------------------------------------
         --FUNCAO VB - GeraMovimentoDevolucoesContabil
         ------------------------------------------------------------------------------------------------------------------------------
		 PRINT 'EXEC 10 '+CONVERT(VARCHAR, GETDATE(), 108);
         EXEC P_EXP_CTB_MOV_DEV_VENDA 
              @CD_EMP,
              @CD_FILIAL,
              @DT_INI,
              @DT_FIM;
					
         ------------------------------------------------------------------------------------------------------------------------------
         --FUNCAO VB - GeraMovimentoDespesas
         ------------------------------------------------------------------------------------------------------------------------------
		 PRINT 'EXEC 11 '+CONVERT(VARCHAR, GETDATE(), 108);
         EXEC P_EXP_CTB_MOV_DESP 
              @CD_EMP,
              @CD_FILIAL,
              @DT_INI,
              @DT_FIM;
					
         ------------------------------------------------------------------------------------------------------------------------------
         --FUNCAO VB - GeraMovimentoDoacaoValores
         ------------------------------------------------------------------------------------------------------------------------------
		 PRINT 'EXEC 12 '+CONVERT(VARCHAR, GETDATE(), 108);
         EXEC P_EXP_CTB_MOV_DOACAO 
              @CD_EMP,
              @CD_FILIAL,
              @DT_INI,
              @DT_FIM;
			  
         ------------------------------------------------------------------------------------------------------------------------------
         --FUNCAO VB - GeraMovimentoComissoesCartoes
         ------------------------------------------------------------------------------------------------------------------------------
		 PRINT 'EXEC 13 '+CONVERT(VARCHAR, GETDATE(), 108);
         EXEC P_EXP_CTB_MOV_COMIS_CARTAO 
              @CD_EMP,
              @CD_FILIAL,
              @DT_INI,
              @DT_FIM;
			  
         ------------------------------------------------------------------------------------------------------------------------------
         --FUNCAO VB - GeraMovimentoTransfLojaMatriz
         ------------------------------------------------------------------------------------------------------------------------------
		 PRINT 'EXEC 14 '+CONVERT(VARCHAR, GETDATE(), 108);
         EXEC P_EXP_CTB_MOV_TRANSF_LOJA_MATRIZ 
              @CD_EMP,
              @CD_FILIAL,
              @DT_INI,
              @DT_FIM;
			  
         ------------------------------------------------------------------------------------------------------------------------------
         --FUNCAO VB - GeraMovimentoAjusteCaixa
         ------------------------------------------------------------------------------------------------------------------------------
		 PRINT 'EXEC 15 '+CONVERT(VARCHAR, GETDATE(), 108);
         EXEC P_EXP_CTB_MOV_AJUSTE_CAIXA 
              @CD_EMP,
              @CD_FILIAL,
              @DT_INI,
              @DT_FIM;
			  
         ------------------------------------------------------------------------------------------------------------------------------
         --FUNCAO VB - GeraMovimentoDuplicatasPagarApropriarSemVinculoDespesa
         ------------------------------------------------------------------------------------------------------------------------------
		 PRINT 'EXEC 16 '+CONVERT(VARCHAR, GETDATE(), 108);
         EXEC P_EXP_CTB_MOV_PG_CRED_APROP_SEM_VINC_DESP 
              @CD_EMP,
              @CD_FILIAL,
              @DT_INI,
              @DT_FIM;
			  
         ------------------------------------------------------------------------------------------------------------------------------
         --FUNCAO VB - GeraMovimentoNotasEmitidas
         ------------------------------------------------------------------------------------------------------------------------------
		 PRINT 'EXEC 17 '+CONVERT(VARCHAR, GETDATE(), 108);
         EXEC P_EXP_CTB_MOV_EST_NF_SAI 
              @CD_EMP,
              @CD_FILIAL,
              @DT_INI,
              @DT_FIM;	
	
         --#########################################################################
				
         ------------------------------------------------------------------------------------------------------------------------------
         --FUNCAO VB - GeraMovimentoDuplicatasPagarApropriar
         ------------------------------------------------------------------------------------------------------------------------------
		 PRINT 'EXEC 18 '+CONVERT(VARCHAR, GETDATE(), 108);
         EXEC P_EXP_CTB_MOV_PG_CRED_APROP 
              @CD_EMP,
              @CD_FILIAL,
              @DT_INI,
              @DT_FIM;
			  
	   --SELECT *
    --             FROM ##CTB_EXP_MOV 
         ------------------------------------------------------------------------------------------------------------------------------
         --FUNCAO VB - GeraMovimentoDuplicatasPagar
         ------------------------------------------------------------------------------------------------------------------------------
		 PRINT 'EXEC 19 '+CONVERT(VARCHAR, GETDATE(), 108);
         EXEC P_EXP_CTB_MOV_PG_CRED 
              @CD_EMP,
              @CD_FILIAL,
              @DT_INI,
              @DT_FIM;
			  
         ------------------------------------------------------------------------------------------------------------------------------
         --FUNCAO VB - GeraMovimentoDuplicatasReceber
         ------------------------------------------------------------------------------------------------------------------------------
		 PRINT 'EXEC 20 '+CONVERT(VARCHAR, GETDATE(), 108);

		 IF @TIPO_RECBTO_CLIENTE = 1  
			
				BEGIN 

					 EXEC P_EXP_CTB_MOV_RC_CRED_MOEDAS 
						  @CD_EMP,
						  @CD_FILIAL,
						  @DT_INI,
						  @DT_FIM;
				END 
		  ELSE
				 BEGIN 

					 EXEC P_EXP_CTB_MOV_RC_CRED 
						  @CD_EMP,
						  @CD_FILIAL,
						  @DT_INI,
						  @DT_FIM;
				 END
			  
         ------------------------------------------------------------------------------------------------------------------------------
         --FUNCAO VB - GeraMovimentoDuplicatasReceberLote
         ------------------------------------------------------------------------------------------------------------------------------
		 PRINT 'EXEC 21 '+CONVERT(VARCHAR, GETDATE(), 108);
         EXEC P_EXP_CTB_MOV_RC_CRED_LOTE --AQUI
              @CD_EMP,
              @CD_FILIAL,
              @DT_INI,
              @DT_FIM;
			  
         ------------------------------------------------------------------------------------------------------------------------------
         --FUNCAO VB - GeraMovimentoBancarioDespesas
         ------------------------------------------------------------------------------------------------------------------------------
		 PRINT 'EXEC 22 '+CONVERT(VARCHAR, GETDATE(), 108);
         EXEC P_EXP_CTB_MOV_BC_LANC_DESP 
              @CD_EMP,
              @CD_FILIAL,
              @DT_INI,
              @DT_FIM;
			  
         ------------------------------------------------------------------------------------------------------------------------------
         --FUNCAO VB - GeraMovimentoBancarioReceitas
         ------------------------------------------------------------------------------------------------------------------------------
		 PRINT 'EXEC 23 '+CONVERT(VARCHAR, GETDATE(), 108);
         EXEC P_EXP_CTB_MOV_BC_LANC_REC 
              @CD_EMP,
              @CD_FILIAL,
              @DT_INI,
              @DT_FIM;
			  
         ------------------------------------------------------------------------------------------------------------------------------
         --FUNCAO VB - GeraMovimentoDepositoCheques
         ------------------------------------------------------------------------------------------------------------------------------
		 PRINT 'EXEC 24 '+CONVERT(VARCHAR, GETDATE(), 108);
         EXEC P_EXP_CTB_MOV_CHQ_DEPOS 
              @CD_EMP,
              @CD_FILIAL,
              @DT_INI,
              @DT_FIM;
			  
         ------------------------------------------------------------------------------------------------------------------------------
         --FUNCAO VB - GeraMovimentoRedepositoCheques
         ------------------------------------------------------------------------------------------------------------------------------
		 PRINT 'EXEC 25 '+CONVERT(VARCHAR, GETDATE(), 108);
         EXEC P_EXP_CTB_MOV_CHQ_REDEPOS 
              @CD_EMP,
              @CD_FILIAL,
              @DT_INI,
              @DT_FIM;
			  
         ------------------------------------------------------------------------------------------------------------------------------
         --FUNCAO VB - GeraMovimentoEnvioChequesCobranca
         ------------------------------------------------------------------------------------------------------------------------------
		 PRINT 'EXEC 26 '+CONVERT(VARCHAR, GETDATE(), 108);
         EXEC P_EXP_CTB_MOV_CHQ_DEST_ENV 
              @CD_EMP,
              @CD_FILIAL,
              @DT_INI,
              @DT_FIM;
			  
         ------------------------------------------------------------------------------------------------------------------------------
         --FUNCAO VB - GeraMovimentoRecebimentoChequesCobranca
         ------------------------------------------------------------------------------------------------------------------------------
		 PRINT 'EXEC 27 '+CONVERT(VARCHAR, GETDATE(), 108);
         EXEC P_EXP_CTB_MOV_CHQ_DEST_ENV_RECTO 
              @CD_EMP,
              @CD_FILIAL,
              @DT_INI,
              @DT_FIM;
			  
         ------------------------------------------------------------------------------------------------------------------------------
         --FUNCAO VB - GeraMovimentoRecebimentoChequesTesouraria
         ------------------------------------------------------------------------------------------------------------------------------
		 PRINT 'EXEC 28 '+CONVERT(VARCHAR, GETDATE(), 108);
         EXEC P_EXP_CTB_MOV_BC_LANC_CHQ_DEST_ENV_CPL 
              @CD_EMP,
              @CD_FILIAL,
              @DT_INI,
              @DT_FIM;
			  
         ------------------------------------------------------------------------------------------------------------------------------
         --FUNCAO VB - GeraMovimentoDevolucaoCheques
         ------------------------------------------------------------------------------------------------------------------------------
		 PRINT 'EXEC 29 '+CONVERT(VARCHAR, GETDATE(), 108);
         EXEC P_EXP_CTB_MOV_CHQ_DEVO 
              @CD_EMP,
              @CD_FILIAL,
              @DT_INI,
              @DT_FIM;
			  
         ------------------------------------------------------------------------------------------------------------------------------
         --FUNCAO VB - GeraMovimentoTransferenciaBancaria
         ------------------------------------------------------------------------------------------------------------------------------
		 PRINT 'EXEC 30 '+CONVERT(VARCHAR, GETDATE(), 108);
         EXEC P_EXP_CTB_MOV_BC_LANC_TRANSF 
              @CD_EMP,
              @CD_FILIAL,
              @DT_INI,
              @DT_FIM;
			  
         ------------------------------------------------------------------------------------------------------------------------------
         --ATUALIZANDO AS CONTAS CONTÁBEIS DA FILIAL E MATRIZ
         ------------------------------------------------------------------------------------------------------------------------------
		 PRINT 'EXEC 31 '+CONVERT(VARCHAR, GETDATE(), 108);
         EXEC P_EXP_CTB_MOV_CNT_CTB_FILIAIS;
		 
         IF @FLAG_CONSULTAR = 0
             BEGIN
                 IF @TIPO = 0   -- DIA SEGUINTE
                     BEGIN
                         ------------------------------------------------------------------------------------------------------------------------------
                         --DELETANDO OS REGISTROS DE EXPORTACAO DO MESMO MOVIMENTO, EXCETO O P_EXP_CTB_MOV_AJUSTE_CAIXA(CD_MOVIMENTO = 12) POIS O MESMO 
                         --É SEMPRE LANÇADO NO DIA SEGUINTE
                         ------------------------------------------------------------------------------------------------------------------------------
						 PRINT 'DELETE 32 '+CONVERT(VARCHAR, GETDATE(), 108);
                         DELETE FROM CTB_EXP_MOV
                         WHERE EXISTS
                         (
                             SELECT MOV.CD_EMP
                             FROM ##CTB_EXP_MOV MOV
                             WHERE MOV.CD_EMP = CTB_EXP_MOV.CD_EMP
                                   AND MOV.CD_FILIAL_EXPORT = CTB_EXP_MOV.CD_FILIAL_EXPORT
                         )
                               AND CTB_EXP_MOV.DT_MOV BETWEEN @DT_INI AND @DT_FIM
                               AND CTB_EXP_MOV.CD_MOVIMENTO <> 12;
							   
						 PRINT 'DELETE 33 '+CONVERT(VARCHAR, GETDATE(), 108);
                         DELETE FROM CTB_EXP_MOV
                         WHERE EXISTS
                         (
                             SELECT MOV.CD_EMP
                             FROM ##CTB_EXP_MOV MOV
                             WHERE MOV.CD_EMP = CTB_EXP_MOV.CD_EMP
                                   AND MOV.CD_FILIAL_EXPORT = CTB_EXP_MOV.CD_FILIAL_EXPORT
                         )
                               AND CTB_EXP_MOV.DT_MOV BETWEEN DATEADD(DAY, 1, @DT_INI) AND DATEADD(DAY, 1, @DT_FIM)
                               AND CTB_EXP_MOV.CD_MOVIMENTO = 12;
                     END;
                 ELSE
                     BEGIN 
                         ------------------------------------------------------------------------------------------------------------------------------
                         --DELETANDO OS REGISTROS DE EXPORTACAO DO MESMO MOVIMENTO
                         ------------------------------------------------------------------------------------------------------------------------------
						 PRINT 'DELETE 34 '+CONVERT(VARCHAR, GETDATE(), 108);
                         DELETE FROM CTB_EXP_MOV
                         WHERE EXISTS
                         (
                             SELECT MOV.CD_EMP
                             FROM ##CTB_EXP_MOV MOV
                             WHERE MOV.CD_EMP = CTB_EXP_MOV.CD_EMP
                                   AND MOV.CD_FILIAL_EXPORT = CTB_EXP_MOV.CD_FILIAL_EXPORT
                         )
                               AND CTB_EXP_MOV.DT_MOV BETWEEN @DT_INI AND @DT_FIM;

                     END;
															
		
                 ------------------------------------------------------------------------------------------------------------------------------
                 --INSERINDO DADOS PARA TABELA DE MOVIMENTO DEFINITIVA
                 ------------------------------------------------------------------------------------------------------------------------------	
				 PRINT 'INSERT 35 '+CONVERT(VARCHAR, GETDATE(), 108);				 
                 INSERT INTO CTB_EXP_MOV(
						CD_EMP
					   ,CD_FILIAL
					   ,MOVIMENTO
					   ,OPERACAO
					   ,OPERACAO_DEBITO
					   ,CD_CNT_RED
					   ,CD_CNT
					   ,CD_CNT_RED_DEBITO
					   ,CD_CNT_DEBITO
					   ,DT_MOV
					   ,HIST
					   ,VLR_LANC
					   ,TP_TRANSA
					   ,RATEIO_CENTRO_CUSTO
					   ,DS_CENTRO_CUSTO
					   ,CNT_CENTRO_CUSTO
					   ,VLR_CENTRO_CUSTO
					   ,ORIG_CONTA
					   ,COD_CONTA
					   ,NM_PROCEDURE
					   ,DT_GERACAO
					   ,CD_MOVIMENTO
					   ,CD_FILIAL_EXPORT
					   ,TIPO_LANCTO
					   ,CD_EVENTO
					   , NR_DP
					   , ANO
					   ,NR_DOC 
					   , CD_BC_LANC
					   , CD_CENTRO_CTB_REDU
					   ,COD_INTERNO
					   ,LOTE
						, COD_INTERNO_DOMINIO
						, CD_BC)
                        SELECT CD_EMP
                             , CD_FILIAL
                             , MOVIMENTO
                             , OPERACAO
                             , OPERACAO_DEBITO
                             , CD_CNT_RED_CREDITO
                             , CD_CNT_CREDITO
                             , CD_CNT_RED_DEBITO
                             , CD_CNT_DEBITO
                             , DT_MOV
                             , HIST
                             , VLR_LANC
                             , TP_TRANSA
                             , RATEIO_CENTRO_CUSTO
                             , DS_CENTRO_CUSTO
                             , CNT_CENTRO_CUSTO
                             , VLR_CENTRO_CUSTO
                             , ORIG_CONTA
                             , COD_CONTA
                             , NM_PROCEDURE
                             , GETDATE() AS DT_GERACAO
                             , CD_MOVIMENTO
                             , CD_FILIAL_EXPORT
                             , TIPO_LANCTO
                             , CD_EVENTO
					         , NR_DP
					         , ANO
					         , NR_DOC 
						    , CD_BC_LANC
						    ,ISNULL(CD_CENTRO_CTB_REDU,0)
							,COD_INTERNO
							,LOTE
							, COD_INTERNO_DOMINIO
							, CD_BC
                        FROM ##CTB_EXP_MOV M;

			--Inserindo os centros de custos dos lancamentos contabeis contas a pagar 
			PRINT 'INSERT 36 '+CONVERT(VARCHAR, GETDATE(), 108);
			INSERT INTO CTB_EXP_MOV_CENTRO_CUSTO ( CD_LANC,CD_CENTRO_CTB,VLR_RAT_DESP)
			SELECT DISTINCT 
				CTB_EXP_MOV.CD_LANC,
				C.CD_CENTRO_CTB,
				C.VLR_RAT_CENTRO_CUSTO
			FROM
				CTB_EXP_MOV LEFT OUTER JOIN CTB_EXP_MOV_CENTRO_CUSTO ON
				CTB_EXP_MOV.CD_LANC = CTB_EXP_MOV_CENTRO_CUSTO.CD_LANC 
				INNER JOIN V_PG_DESP_RAT_CONTAS_CENTRO_CUSTO_PAGAR_CONTABIL C ON
				CTB_EXP_MOV.CD_EMP = C.CD_EMP AND
				CTB_EXP_MOV.CD_FILIAL = C.CD_FILIAL AND
				CTB_EXP_MOV.COD_CONTA = C.CD_DESP_REC AND
				--CTB_EXP_MOV.NR_DP = C.NR_DP AND
				(CAST(CTB_EXP_MOV.NR_DP AS VARCHAR(32))) = CAST(CTB_EXP_MOV.CD_FILIAL AS VARCHAR(3)) + CAST(C.NR_DP AS VARCHAR(32)) AND

				CTB_EXP_MOV.ANO = C.ANO
			WHERE
				CTB_EXP_MOV.RATEIO_CENTRO_CUSTO=1
				AND CTB_EXP_MOV_CENTRO_CUSTO.CD_LANC IS NULL
				AND CTB_EXP_MOV.DT_MOV BETWEEN @DT_INI AND @DT_FIM

				 -- SELECT * FROM V_PG_DESP_RAT_CONTAS_CENTRO_CUSTO_PAGAR_CONTABIL WHERE  NR_DP = 1700018    AND ANO =2017 AND CD_FILIAL = 1
				 -- SELECT * FROM CTB_EXP_MOV WHERE DT_MOV BETWEEN '20170104' and '20170104' AND CD_MOVIMENTO = 15

				 --SELECT * FROM CTB_EXP_MOV_CENTRO_CUSTO WHERE CD_LANC IN ( SELECT CD_LANC FROM CTB_EXP_MOV WHERE DT_MOV BETWEEN '20170104' and '20170104') --AND CD_MOVIMENTO = 15)
				  PRINT 'inserindo CTB_EXP_MOV_CENTRO_CUSTO '

			--Inserindo os centros de custos dos lancamentos contabeis lancamentos direto no bancario
			PRINT 'INSERT 37 '+CONVERT(VARCHAR, GETDATE(), 108);

			INSERT INTO CTB_EXP_MOV_CENTRO_CUSTO ( CD_LANC,CD_CENTRO_CTB,VLR_RAT_DESP)
			
			SELECT
				CTB_EXP_MOV.CD_LANC,
				C.CD_CENTRO_CTB,
				C.VLR_DESP		    --  SELECT * FROM CTB_EXP_MOV WHERE CD_LANC = 13188416, 36
								    --    SELECT * FROM CTB_EXP_MOV_CENTRO_CUSTO WHERE CD_LANC = 13188416

			FROM
				CTB_EXP_MOV LEFT OUTER JOIN CTB_EXP_MOV_CENTRO_CUSTO ON
				CTB_EXP_MOV.CD_LANC = CTB_EXP_MOV_CENTRO_CUSTO.CD_LANC 
				INNER JOIN V_PG_DESP_RAT_CONTAS_CENTRO_CUSTO_BANCARIO_CONTABIL C ON
				CTB_EXP_MOV.CD_EMP = C.CD_EMP AND      
				CTB_EXP_MOV.CD_BC_LANC = C.CD_BC_LANC
			AND CTB_EXP_MOV.COD_CONTA = C.CD_DESP_REC
			WHERE
				CTB_EXP_MOV.RATEIO_CENTRO_CUSTO=1
				AND CTB_EXP_MOV_CENTRO_CUSTO.CD_LANC IS NULL
				AND CD_CNT_RED > 0  
				AND NOT C.CD_CENTRO_CTB IS NULL 
				AND CTB_EXP_MOV.DT_MOV BETWEEN @DT_INI AND @DT_FIM

             END;
         ELSE
		 
         --RETORNANDO O RESULTADO DA EXPORTACAO CONTABIL
             BEGIN
                 SELECT * 
                 FROM ##CTB_EXP_MOV;
             END;
     END;
	 
	 PRINT 'TRUNCATE 38 '+CONVERT(VARCHAR, GETDATE(), 108);
	 TRUNCATE TABLE ##CTB_EXP_MOV
	 
PRINT 'P_EXP_CTB_EXP_MOV  FINALIZADA!';